<?php
/**
 * @package     CB User API
 * @subpackage  com_cbuserapi
 * @copyright   Copyright (C) 2025. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Dispatcher\ComponentDispatcherFactoryInterface;
use Joomla\CMS\Extension\ComponentInterface;
use Joomla\CMS\Extension\Service\Provider\ComponentDispatcherFactory;
use Joomla\CMS\Extension\Service\Provider\MVCFactory;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Kyle\Component\Cbuserapi\Administrator\Extension\CbuserApiComponent;

/**
 * Service provider for the CB User API component
 */
return new class implements ServiceProviderInterface
{
    /**
     * Registers the service provider with a DI container.
     *
     * @param   Container  $container  The DI container.
     *
     * @return  void
     */
    public function register(Container $container)
    {
        $container->registerServiceProvider(new MVCFactory('\\Kyle\\Component\\Cbuserapi'));
        $container->registerServiceProvider(new ComponentDispatcherFactory('\\Kyle\\Component\\Cbuserapi'));

        $container->set(
            ComponentInterface::class,
            function (Container $container) {
                $component = new CbuserApiComponent($container->get(ComponentDispatcherFactoryInterface::class));
                $component->setMVCFactory($container->get(MVCFactoryInterface::class));

                return $component;
            }
        );
    }
};
