# AI Assistant Button for Joomla

A Joomla plugin that adds an AI-powered assistant button to both TinyMCE and JCE editors, powered by Claude API from Anthropic.

## Description

This editor-xtd plugin integrates Claude AI directly into your Joomla content editors, allowing you to generate, edit, and enhance content using artificial intelligence. The plugin works seamlessly with both TinyMCE and JCE editors, supporting both visual and code editing modes.

## Features

✅ Works with both TinyMCE and JCE editors  
✅ Works in both visual/editor mode AND code mode  
✅ Handles line breaks and formatting properly  
✅ Strips markdown code fences automatically  
✅ Uses a secure AJAX proxy (API key never exposed to browser)  
✅ Has Insert, Replace, and Append functionality  
✅ Shows a nice modal interface  
✅ CSRF token protection for security  
✅ Supports Joomla 5.x  

## Requirements

- Joomla 5.x or higher
- PHP 7.4 or higher with cURL support
- TinyMCE or JCE editor
- Anthropic API key (get one at https://console.anthropic.com/)

## Installation

1. Download the plugin ZIP file
2. Log in to your Joomla administrator panel
3. Go to **Extensions → Install**
4. Upload and install the ZIP file
5. Go to **System → Plugins**
6. Search for "AI Assistant"
7. Click on the plugin to configure it
8. Enter your **Anthropic API Key** in the plugin settings
9. Enable the plugin
10. Click **Save & Close**

## Usage

### For TinyMCE Editor

The AI Assistant option appears in the CMS Content dropdown list.

1. Open any article for editing
2. Pick **AI Assistant** in CMS Content dropdown.
3. Enter your prompt in the modal dialog
4. Choose an action:
   - **Insert**: Insert AI response at cursor position
   - **Replace Selection**: Replace selected text with AI response
   - **Append**: Add AI response to the end of the content
5. The AI-generated content will be inserted into your editor

### For JCE Editor

The AI Assistant button will appear below the text area.

1. Open any article for editing in JCE
2. Click **AI Assistant** button
3. Enter your prompt in the modal dialog
4. You can request HTML when in the JCE's Code mode.
5. Follow the same steps as TinyMCE above


### Code Mode

The plugin also works when editing in code/source mode:

1. Switch to **Code** mode in your editor
2. Click the **AI Assistant** button
3. The AI response will be inserted as raw HTML/text without formatting conversion

## Configuration

### Plugin Settings

- **API Key**: Your Anthropic API key (required)

### Editor Configuration

**For TinyMCE:**
- The AI Assistant appears automatically in the **CMS Content** dropdown menu in the toolbar
- No additional configuration needed

**For JCE:**
- The AI Assistant button appears automatically below the editor
- No additional configuration needed

## Examples

### Generate Content
**Prompt**: "Write a brief introduction about sustainable energy"

### Edit Content
**Prompt**: "Rewrite this paragraph to be more concise: [paste your text]"

### Create Lists
**Prompt**: "Create an HTML bullet list of 5 benefits of solar power"

### Format Code
**Prompt**: "Format this CSS code with proper indentation: [paste code]"

## Security

- API key is stored securely in Joomla database
- Never exposed to browser/frontend
- All API calls go through Joomla AJAX proxy
- CSRF token protection on all requests
- Session validation for AJAX calls

## Troubleshooting

### Button Not Appearing

1. Verify the plugin is **enabled** in System → Plugins
2. Clear Joomla cache (System → Clear Cache)
3. Clear browser cache
4. For JCE: Make sure the "Joomla" button is in your toolbar

### API Errors

1. Verify your API key is correct in plugin settings
2. Check your API usage limits at console.anthropic.com
3. Ensure your server can make HTTPS requests (cURL enabled)

### Insert Not Working

1. Check browser console for JavaScript errors (F12)
2. Verify the editor is active and focused
3. Try switching between visual and code modes

## Technical Details

### File Structure

```
plg_editors-xtd_aibutton/
├── LICENSE                       # GPL 
├── README.md                     # This file
├── aibutton.xml                    # Plugin manifest
├── services/
│   └── provider.php               # Service provider
├── src/
│   └── Extension/
│       └── AIButton.php           # Main plugin class
├── media/
│   ├── js/
│   │   └── aibutton.js           # Frontend JavaScript
│   └── css/
│       └── aibutton.css          # Modal styling
└── language/
    └── en-GB/
        ├── plg_editors-xtd_aibutton.ini
        └── plg_editors-xtd_aibutton.sys.ini
```

### API Integration

The plugin uses the Anthropic Claude API (claude-sonnet-4-20250514 model) with a maximum token limit of 4096 tokens per request.

## License

GNU General Public License version 2 or later

## Credits

Built with:
- Joomla! CMS
- Anthropic Claude API
- Compatible with TinyMCE and JCE editors

## Support

For issues or questions:
- Check Joomla error logs in `administrator/logs/`
- Check browser console for JavaScript errors
- Verify API key and network connectivity

## Changelog

### Version 1.0.0
- Initial release
- Support for TinyMCE and JCE editors
- Visual and code mode support
- Insert, Replace, and Append functionality
- Secure AJAX proxy for API calls
- Automatic markdown code fence stripping

## Author

Kyle Davenport
Email: kdavenpo@tx.rr.com
Website: https://quickening.zapto.org/Useful

## Links

- [Anthropic Console](https://console.anthropic.com/) - Get your API key
- [Claude API Documentation](https://docs.anthropic.com/)
- [Joomla Extensions Directory](https://extensions.joomla.org/)
